//
//  HHReverseGeocoder.h
//  ReverseGeocode
//
//  Created by Pierre Bernard on 7/20/10.
//  Copyright 2010-2015 Houdah Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <CoreLocation/CoreLocation.h>

#import "HHPlacemark.h"
#import "NSValue+HHReverseGeocode.h"


@protocol HHReverseGeocoderDelegate;


@interface HHReverseGeocoder : NSObject

- (instancetype)initWithCoordinates:(NSArray *)inCoordinates options:(NSDictionary*)inOptions;


- (BOOL)start;
- (void)cancel;

@property (nonatomic, copy, readonly)							NSArray								*coordinates;
@property (nonatomic, copy, readonly)							NSDictionary						*options;
@property (nonatomic, weak)										id<HHReverseGeocoderDelegate>		delegate;
@property (nonatomic, copy)										NSArray								*placemarks;
@property (nonatomic, assign, getter=isQuerying)				BOOL								querying;


- (instancetype)initWithCoordinate:(CLLocationCoordinate2D)inCoordinate options:(NSDictionary*)inOptions;

@property (nonatomic, assign, readonly)							CLLocationCoordinate2D				coordinate;
@property (nonatomic, strong)									HHPlacemark							*placemark;

+ (BOOL)preFlightCheck:(NSDictionary*)options outError:(NSError**)preFlightError;

@end


@protocol HHReverseGeocoderDelegate <NSObject>

- (void)reverseGeocoder:(HHReverseGeocoder *)geocoder didFailWithError:(NSError *)error;

@optional
- (void)reverseGeocoder:(HHReverseGeocoder *)geocoder didFindPlacemark:(HHPlacemark *)placemark;
- (void)reverseGeocoder:(HHReverseGeocoder *)geocoder didFindPlacemarks:(NSArray *)placemarks;

@end
